/*
	This software was produced as a part of research
	activities. It is not intended to be used as commercial
	or industrial software by any organisation. Except as
	explicitly stated, no guarantees are given as to its
	reliability or trustworthiness if used for purposes other
	than those for which it was originally intended.
 
	(c) British Telecommunications plc 1999.
*/

(:Rulebase OTCSelling
   (EingangDesBoersenergebnisses0
      (PXTrading (time ?T) (quantity ?PxQty))
      (PXMarketData (mcp ?Mcp) (time ?T))
      ?money <- (Money (amount ?Amount))
      (GMT (time ?GmtTime))
      (CapacityAt (time ?T) (quantity ?CapQty))
      (TradingPeriod (timeTicks ?TimeTicks))
      (LoadForecast (expVal ?ExpLoad) (time ?T))
      (not (TradingOpen (time ?T)))
      (not (OTCTrading (time ?T)))
      =>
      (assert (TradingOpen (deadline (?GmtTime + ?TimeTicks)) (time ?T)))
      (assert (OTCTrading (time ?T) (quantity 0)))
      (assert (OTCAveragePrice (avgprice 0) (time ?T)))
      (assert (Production (time ?T) (quantity (?ExpLoad + ?PxQty))))
      (modify ?money (amount (?Amount + (?Mcp * ?PxQty))))
   )
   (VerkaufangebotErstellen1a
      (TradingOpen (time ?T))
      (CapacityAt (time ?T) (quantity ?CapQty))
      (Production (time ?T) (quantity ?ProdQty) (unitCost ?ProdUnitCost))
      (ProductionCostOnChange (targetQuantity ?TargetQtyPlus) (actualQuantity ?ProdQty) (targetQuantityUnitCost ?PlusUnitCost) (time ?T))
      (ProductionCostOnChange (targetQuantity ?TargetQtyMinus) (actualQuantity ?ProdQty) (targetQuantityUnitCost ?MinusUnitCost) (time ?T))
      (PXMarketData (mcp ?Mcp) (time ?T))
      (test (?ProdQty <= ?TargetQtyPlus))
      (test (?ProdQty >= ?TargetQtyMinus))
      (test (?CapQty >= ?ProdQty))
      (test (((?Mcp - ?PlusUnitCost) * (?TargetQtyPlus - ?ProdQty)) > (((?ProdUnitCost - ?Mcp) * ?ProdQty) + ((?Mcp - ?MinusUnitCost) * ?TargetQtyMinus))))
      =>
      (if (5 < (?TargetQtyPlus - ?ProdQty)) then
 (bind ?supplyQty 5)
 else
 (bind ?supplyQty (?TargetQtyPlus - ?ProdQty)))
      (assert (OTCSupply (status isOpen) (quantity ?supplyQty) (time ?T) (expectedCost ?PlusUnitCost)))
   )
   (VerkaufpreisFestlegen3a
      (OTCSupply (status isOpen) (quantity ?SupQty) (time ?T) (expectedCost ?SupCost) (id ?SupplyId))
      (not (OTCContract (supplyId ?SupplyId)))
      (MyName (name ?TheName))
      (UtilizationRate (rate ?IsRate) (time ?T))
      (UtilizationTarget (rate ?TargetRate) (time ?T))
      (PXMarketData (mcp ?Mcp) (time ?T))
      (TradingOpen (time ?T))
      (RiskAttitude (riskPremium ?RiskPremium))
      (test (?IsRate >= ?TargetRate))
      (test ((?SupCost * (1 + ?RiskPremium)) < ?Mcp))
      =>
      (assert (OTCContract (name ?TheName) (price ?Mcp) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId)))
   )
   (VerkaufpreisFestlegen3b
      (OTCSupply (status isOpen) (quantity ?SupQty) (time ?T) (expectedCost ?SupCost) (id ?SupplyId))
      (not (OTCContract (supplyId ?SupplyId)))
      (MyName (name ?TheName))
      (UtilizationRate (rate ?IsRate) (time ?T))
      (UtilizationTarget (rate ?TargetRate) (time ?T))
      (PXMarketData (mcp ?Mcp) (time ?T))
      (TradingOpen (time ?T))
      (RiskAttitude (threshold ?Threshold) (riskPremium ?RiskPremium))
      (test (?IsRate >= ?TargetRate))
      (test ((?SupCost * (1 + ?RiskPremium)) >= ?Mcp))
      (test (((?SupCost * (1 + ?RiskPremium)) / ?Mcp) <= (1 + ?Threshold)))
      =>
      (assert (OTCContract (name ?TheName) (price (?SupCost * (1 + ?RiskPremium))) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId)))
   )
   (VerkaufpreisFestlegen3c
      (OTCSupply (status isOpen) (quantity ?SupQty) (time ?T) (expectedCost ?SupCost) (id ?SupplyId))
      (not (OTCContract (supplyId ?SupplyId)))
      (MyName (name ?TheName))
      (UtilizationRate (rate ?IsRate) (time ?T))
      (UtilizationTarget (rate ?TargetRate) (time ?T))
      (PXMarketData (mcp ?Mcp) (time ?T))
      (TradingOpen (time ?T))
      (RiskAttitude (threshold ?Threshold) (attitude ?Attitude) (extraPremium ?ExtraPremium) (riskPremium ?RiskPremium))
      (test (?IsRate >= ?TargetRate))
      (test (((?SupCost * (1 + ?RiskPremium)) / ?Mcp) > (1 + ?Threshold)))
      (test (?Attitude != averse))
      =>
      (assert (OTCContract (name ?TheName) (price (?SupCost * (1 + ?ExtraPremium))) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId)))
   )
   (VerkaufpreisFestlegen3d
      (OTCSupply (status isOpen) (quantity ?SupQty) (time ?T) (expectedCost ?SupCost) (id ?SupplyId))
      (not (OTCContract (supplyId ?SupplyId)))
      (MyName (name ?TheName))
      (UtilizationRate (rate ?IsRate) (time ?T))
      (UtilizationTarget (rate ?TargetRate) (time ?T))
      (PXMarketData (mcp ?Mcp) (time ?T))
      (TradingOpen (time ?T))
      (RiskAttitude (threshold ?Threshold) (riskPremium ?RiskPremium))
      (test (?IsRate < ?TargetRate))
      (test (?IsRate > 0))
      (test (?SupCost < ?Mcp))
      =>
      (assert (OTCContract (name ?TheName) (price ?Mcp) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId)))
   )
   (VerkaufpreisFestlegen3e
      (OTCSupply (status isOpen) (quantity ?SupQty) (time ?T) (expectedCost ?SupCost) (id ?SupplyId))
      (not (OTCContract (supplyId ?SupplyId)))
      (MyName (name ?TheName))
      (UtilizationRate (rate ?IsRate) (time ?T))
      (UtilizationTarget (rate ?TargetRate) (time ?T))
      (PXMarketData (mcp ?Mcp) (time ?T))
      (TradingOpen (time ?T))
      (RiskAttitude (threshold ?Threshold) (attitude friendly) (riskPremium ?RiskPremium) (acceptableLoss ?AcceptableLoss))
      (test (?IsRate < ?TargetRate))
      (test (?IsRate > 0))
      (test (?SupCost >= ?Mcp))
      (test (((?SupCost / ?Mcp) - 1) <= ?AcceptableLoss))
      =>
      (assert (OTCContract (name ?TheName) (price (?SupCost * (1 - ?AcceptableLoss))) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId)))
   )
   (VerkaufpreisFestlegen3f
      (OTCSupply (status isOpen) (quantity ?SupQty) (time ?T) (expectedCost ?SupCost) (id ?SupplyId))
      (not (OTCContract (supplyId ?SupplyId)))
      (MyName (name ?TheName))
      (UtilizationRate (rate 0) (time ?T))
      =>
      (assert (OTCContract (name ?TheName) (price ?SupCost) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId)))
   )
   (ErfolgreichenVerkaufVerbuchen4a
      ?otcSupply <- (OTCSupply (status selling) (time ?T) (quantity ?SupQty) (expectedCost ?SupPrice) (id ?SupplyId))
      ?utilization <- (UtilizationRate (rate ?IsRate) (time ?T))
      ?production <- (Production (quantity ?ProdQty) (time ?T))
      ?otcAveragePrice <- (OTCAveragePrice (avgprice ?AvgPrice) (time ?T))
      ?otcTrading <- (OTCTrading (quantity ?TradingQty) (time ?T))
      (MyName (name ?MyName))
      (CapacityAt (time ?T) (quantity ?CapQty))
      (not (RiskAttitude (attitude averse)))
      (TradingOpen (time ?T))
      (OTCContract (status sold) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId))
      (test (?CapQty >= (?ProdQty + ?SupQty)))
      =>
      (modify ?otcSupply (status sold))
      (modify ?otcTrading (quantity (?TradingQty + ?SupQty)))
      (modify ?otcAveragePrice (avgprice (((?AvgPrice * ?TradingQty) + (?SupQty * ?SupPrice)) / (?TradingQty + ?SupQty))))
      (modify ?production (quantity (?ProdQty + ?SupQty)))
   )
   (ErfolgreichenVerkaufVerbuchen4b
      ?otcSupply <- (OTCSupply (status selling) (time ?T) (quantity ?SupQty) (expectedCost ?SupPrice) (id ?supplyId))
      ?utilization <- (UtilizationRate (rate ?IsRate) (time ?T))
      ?production <- (Production (quantity ?ProdQty) (time ?T))
      ?otcAveragePrice <- (OTCAveragePrice (avgprice ?AvgPrice) (time ?T))
      ?otcTrading <- (OTCTrading (quantity ?TradingQty) (time ?T))
      (MyName (name ?MyName))
      (LoadForecast (time ?T) (stddev ?Stddev))
      (CapacityAt (time ?T) (quantity ?CapQty))
      (RiskAttitude (attitude averse))
      (TradingOpen (time ?T))
      (OTCContract (status sold) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId))
      (test (?CapQty >= ((?ProdQty + ?SupQty) + ?Stddev)))
      =>
      (modify ?otcSupply (status sold))
      (modify ?otcTrading (quantity (?TradingQty + ?SupQty)))
      (modify ?otcAveragePrice (avgprice (((?AvgPrice * ?TradingQty) + (?SupQty * ?SupPrice)) / (?TradingQty + ?SupQty))))
      (modify ?production (quantity (?ProdQty + ?SupQty)))
   )
   (ErfolgreichenVerkaufVerbuchen4c
      ?otcSupply <- (OTCSupply (status selling) (time ?T) (quantity ?SupQty) (expectedCost ?SupPrice) (id ?supplyId))
      ?utilization <- (UtilizationRate (rate ?IsRate) (time ?T))
      ?production <- (Production (quantity ?ProdQty) (time ?T))
      ?otcAveragePrice <- (OTCAveragePrice (avgprice ?AvgPrice) (time ?T))
      ?otcTrading <- (OTCTrading (quantity ?TradingQty) (time ?T))
      (MyName (name ?MyName))
      (CapacityAt (time ?T) (quantity ?CapQty))
      (SpinningReserve (price ?SprPrice))
      (not (RiskAttitude (attitude averse)))
      (TradingOpen (time ?T))
      (OTCContract (status sold) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId))
      (test (?CapQty < (?ProdQty + ?SupQty)))
      =>
      (assert (OTCDemand (status init) (quantity ((?ProdQty + ?SupQty) - ?CapQty)) (expectedCost ?SprPrice)))
      (modify ?otcSupply (status sold))
      (modify ?otcTrading (quantity (?TradingQty + ?SupQty)))
      (modify ?otcAveragePrice (avgprice (((?AvgPrice * ?TradingQty) + (?SupQty * ?SupPrice)) / (?TradingQty + ?SupQty))))
      (modify ?production (quantity (?ProdQty + ?SupQty)))
   )
   (ErfolgreichenVerkaufVerbuchen4d
      ?otcSupply <- (OTCSupply (status selling) (time ?T) (quantity ?SupQty) (expectedCost ?SupPrice) (id ?supplyId))
      ?utilization <- (UtilizationRate (rate ?IsRate) (time ?T))
      ?production <- (Production (quantity ?ProdQty) (time ?T))
      ?otcAveragePrice <- (OTCAveragePrice (avgprice ?AvgPrice) (time ?T))
      ?otcTrading <- (OTCTrading (quantity ?TradingQty) (time ?T))
      (MyName (name ?MyName))
      (LoadForecast (time ?T) (stddev ?Stddev))
      (CapacityAt (time ?T) (quantity ?CapQty))
      (RiskAttitude (attitude averse))
      (TradingOpen (time ?T))
      (OTCContract (status sold) (time ?T) (quantity ?SupQty) (supplyId ?SupplyId))
      (test (?CapQty < ((?ProdQty + ?SupQty) + ?Stddev)))
      =>
      (assert (OTCDemand (status init) (quantity ((?ProdQty + ?SupQty) - ?CapQty)) (expectedCost ?SprPrice)))
      (modify ?otcSupply (status sold))
      (modify ?otcTrading (quantity (?TradingQty + ?SupQty)))
      (modify ?otcAveragePrice (avgprice (((?AvgPrice * ?TradingQty) + (?SupQty * ?SupPrice)) / (?TradingQty + ?SupQty))))
      (modify ?production (quantity (?ProdQty + ?SupQty)))
   )
)
